/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.api.internal.connection;

import com.pushtechnology.diffusion.api.internal.connection.ClientType;
import com.pushtechnology.diffusion.api.internal.connection.TransportType;
import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import java.util.HashMap;
import java.util.Map;

public enum InternalConnectionType {
    UNSPECIFIED_CLIENT("Unspecified Client", "X", TransportType.OTHER, ClientType.OTHER),
    WEBSOCKET_JAVA_CLIENT("WebSocket Java Client", "WJ", TransportType.WEBSOCKET, ClientType.JAVA),
    HTTP_JAVA_CLIENT("HTTP Java Client", "JXHR", TransportType.HTTP_LONG_POLL, ClientType.JAVA),
    WEBSOCKET_ANDROID_CLIENT("WebSocket Android Client", "WA", TransportType.WEBSOCKET, ClientType.ANDROID),
    HTTP_ANDROID_CLIENT("HTTP Android Client", "AXHR", TransportType.HTTP_LONG_POLL, ClientType.ANDROID),
    REST_CLIENT("REST Client", "RC", TransportType.TCP, ClientType.REST),
    WEBSOCKET_JAVASCRIPT_CLIENT("WebSocket JavaScript Client", "WB", TransportType.WEBSOCKET, ClientType.JAVASCRIPT_BROWSER),
    HTTP_JAVASCRIPT_CLIENT("HTTP JavaScript Client", "B", TransportType.HTTP_LONG_POLL, ClientType.JAVASCRIPT_BROWSER),
    WEBSOCKET_DOTNET_CLIENT("WebSocket .NET Client", "WN", TransportType.WEBSOCKET, ClientType.DOTNET),
    HTTP_DOTNET_CLIENT("HTTP .Net Client", "N", TransportType.HTTP_LONG_POLL, ClientType.DOTNET),
    WEBSOCKET_IOS_CLIENT("WebSocket iOS Client", "WIOS", TransportType.WEBSOCKET, ClientType.IOS),
    WEBSOCKET_C_CLIENT("WebSocket C Client", "WC", TransportType.WEBSOCKET, ClientType.C),
    WEBSOCKET_FANOUT_CLIENT("WebSocket Fan-out Client", "WSFC", TransportType.WEBSOCKET, ClientType.JAVA),
    HTTP_FANOUT_CLIENT("HTTP Fan-out Client", "JPFC", TransportType.HTTP_LONG_POLL, ClientType.JAVA),
    WEBSOCKET_SERVER_CLIENT("WebSocket Server Client", "WSSC", TransportType.WEBSOCKET, ClientType.JAVA),
    HTTP_SERVER_CLIENT("HTTP Server Client", "PSC", TransportType.HTTP_LONG_POLL, ClientType.JAVA),
    CLUSTER_PEER_CLIENT("Cluster peer Client", "CPC", TransportType.WEBSOCKET, ClientType.JAVA),
    WEBSOCKET_PYTHON_CLIENT("WebSocket Python Client", "PY", TransportType.WEBSOCKET, ClientType.PYTHON),
    MQTT_TCP_CLIENT("MQTT TCP Client", "MQTT-TCP", TransportType.TCP, ClientType.MQTT),
    MQTT_WEBSOCKET_CLIENT("MQTT WebSocket Client", "MQTT-WS", TransportType.WEBSOCKET, ClientType.MQTT),
    WEBSOCKET_JAVA_GATEWAY_CLIENT("WebSocket Java Gateway Client", "WJGC", TransportType.WEBSOCKET, ClientType.JAVA),
    WEBSOCKET_REVERSE_SERVER("WebSocket Reverse Server", "REV-WS", TransportType.WEBSOCKET, ClientType.JAVA),
    WEBSOCKET_REVERSE_CLIENT("WebSocket Reverse Client", "WSSCR", TransportType.WEBSOCKET, ClientType.JAVA),
    USAGE_PROVIDER_CLIENT("Usage Provider Client", "UPC", TransportType.WEBSOCKET, ClientType.JAVA);

    private final String displayName;
    private final String headerValue;
    private final TransportType transportType;
    private final ClientType clientType;
    private static final Map<String, InternalConnectionType> BY_HEADER;
    public static final EnumConverter<InternalConnectionType> TYPE_CONVERTER;

    private InternalConnectionType(String displayName, String headerValue, TransportType transportType, ClientType clientType) {
        this.displayName = displayName;
        this.headerValue = headerValue;
        this.transportType = transportType;
        this.clientType = clientType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ClientType getClientType() {
        return this.clientType;
    }

    public boolean isFanOut() {
        return this == WEBSOCKET_FANOUT_CLIENT || this == HTTP_FANOUT_CLIENT;
    }

    public boolean isRemoteServer() {
        return this == WEBSOCKET_SERVER_CLIENT || this == WEBSOCKET_REVERSE_CLIENT || this == HTTP_SERVER_CLIENT || this.isFanOut();
    }

    public boolean isGatewayClient() {
        return this == WEBSOCKET_JAVA_GATEWAY_CLIENT;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    public static InternalConnectionType byHeader(String headerValue) {
        return BY_HEADER.get(headerValue);
    }

    static {
        BY_HEADER = new HashMap<String, InternalConnectionType>();
        for (InternalConnectionType ct : InternalConnectionType.values()) {
            String headerValue = ct.headerValue;
            if (headerValue == null) continue;
            BY_HEADER.put(headerValue, ct);
        }
        TYPE_CONVERTER = new EnumConverter.Builder<InternalConnectionType>(InternalConnectionType.class).bimap(0, UNSPECIFIED_CLIENT).bimap(1, WEBSOCKET_JAVA_CLIENT).bimap(2, HTTP_JAVA_CLIENT).bimap(3, WEBSOCKET_ANDROID_CLIENT).bimap(4, HTTP_ANDROID_CLIENT).bimap(5, REST_CLIENT).bimap(6, WEBSOCKET_JAVASCRIPT_CLIENT).bimap(7, HTTP_JAVASCRIPT_CLIENT).bimap(8, WEBSOCKET_DOTNET_CLIENT).bimap(9, HTTP_DOTNET_CLIENT).bimap(10, WEBSOCKET_IOS_CLIENT).bimap(11, WEBSOCKET_C_CLIENT).bimap(12, WEBSOCKET_FANOUT_CLIENT).bimap(13, HTTP_FANOUT_CLIENT).bimap(14, WEBSOCKET_SERVER_CLIENT).bimap(15, HTTP_SERVER_CLIENT).bimap(16, CLUSTER_PEER_CLIENT).bimap(17, WEBSOCKET_PYTHON_CLIENT).bimap(18, MQTT_TCP_CLIENT).bimap(19, MQTT_WEBSOCKET_CLIENT).bimap(20, WEBSOCKET_JAVA_GATEWAY_CLIENT).bimap(21, WEBSOCKET_REVERSE_SERVER).bimap(22, WEBSOCKET_REVERSE_CLIENT).bimap(23, USAGE_PROVIDER_CLIENT).build();
    }
}

