/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework;

import java.util.concurrent.CompletableFuture;

/**
 * Handler called when any session subscribes using a topic selector that
 * matches no topics.
 *
 * <p>
 * Its instances can be registered using
 * {@link Publisher#addMissingTopicHandler(String, MissingTopicNotificationHandler)}.
 * <p>
 *
 * @author DiffusionData Limited
 */
public interface MissingTopicNotificationHandler {
    /**
     * Handle passed missing topic notification.
     * <p>
     * This is called when a missing topic notification is received from the server.
     * <p>
     * A service can do anything upon receiving this notification, such as
     * publishing to a topic for which the notification is received (which
     * will create the topic).
     *
     * @param missingTopicNotification a missing topic notification
     *
     * @return a CompletableFuture that should complete once handling the
     *         notification is complete.
     *         <p>
     *         If the task completes successfully, the CompletableFuture result
     *         should be null. The result type is any rather than Void to provide
     *         forward compatibility with future iterations of this API that may
     *         provide a non-null result with a more specific result type.
     *         <p>
     *         If the task fails, the CompletableFuture should complete
     *         exceptionally.
     */
    CompletableFuture<?> onMissingTopic(
        MissingTopicNotification missingTopicNotification);
}
